events.listen('recipes', event => {

    var mekcrush = event.recipes.mekanism.crushing
    var removeOut = function (item) {
      event.remove({output: item})
    }
    var removeIn = function (item) {
      event.remove({input: item})
    }
    var removeId = function (id) {
      event.remove({id: id})
    }
    var mekenrichItem = function (item, iCount, result, rCount) {
        event.recipes.mekanism.enriching({
            input: {
                amount: iCount,
                ingredient: {
                  item: item
                }
            },
            output: {
                item: result,
                count: rCount
            }
        })
    }
    var mekenrichTag = function (tag, iCount, result, rCount) {
        event.recipes.mekanism.enriching({
            input: {
                amount: iCount,
                ingredient: {
                    tag: tag
                }
            },
            output: {
                item: result,
                count: rCount
            }
        })
    }
    var energize = function(ingredient, result, rCount, power) {
      event.recipes.powah.energizing({
        ingredients: ingredient,
        energy: power,
        result: {
          item: result,
          count: rCount
        }
      })
    }
    var pressure = function(inputs, result, rCount, pressure) {
      event.recipes.pneumaticcraft.pressure_chamber(
        {
          inputs: inputs,
          pressure: pressure,
          results: [
            {
              item: result,
              count: rCount
            }
          ]
        }
      )
    }
  
    //Make bio fuel use tags instead of invidual items
    removeOut('mekanism:bio_fuel')
    mekcrush(item.of('mekanism:bio_fuel', 2), '#misctags:biofuel2')
    mekcrush(item.of('mekanism:bio_fuel', 4), '#misctags:biofuel4')
    mekcrush(item.of('mekanism:bio_fuel', 5), '#misctags:biofuel5')
    mekcrush(item.of('mekanism:bio_fuel', 7), '#misctags:biofuel7')
    mekcrush(item.of('mekanism:bio_fuel', 8), '#misctags:biofuel8')
  
    //Recipes for AE2 dusts
    mekcrush(item.of('appliedenergistics2:certus_quartz_dust'), '#forge:gems/certus_quartz')
    mekcrush(item.of('appliedenergistics2:ender_dust'), '#forge:ender_pearls')
    mekcrush(item.of('appliedenergistics2:fluix_dust'), '#appliedenergistics2:crystals/fluix')
    
    //Powah recipes
    energize([{tag: 'forge:storage_blocks/iron'},{tag: 'forge:storage_blocks/gold'}], 'powah:energized_steel_block', 2, 90000)
    energize([{item: 'botania:blaze_block'}], 'powah:blazing_crystal_block', 1, 810000)
    energize([{tag: 'forge:storage_blocks/diamond'}], 'powah:niotic_crystal_block', 1, 2700000)
    energize([{tag: 'forge:storage_blocks/emerald'}], 'powah:spirited_crystal_block', 1, 9000000)

    //Misc recipes
    event.recipes.appliedenergistics2.inscriber({
        mode: 'inscribe',
        result: {
          item: 'appliedenergistics2:printed_silicon'
        },
        ingredients: {
          top: {
            item: 'appliedenergistics2:silicon_press'
          },
          middle: {
            tag: 'forge:silicon'
          }
        }
    })
    event.recipes.industrialforegoing.dissolution_chamber({
      input: [
        {
          tag: 'minecraft:planks'
        }
      ],
      inputFluid: '{FluidName:\'immersiveengineering:creosote\',Amount:125}',
      processingTime: 1,
      output: {
        item: 'immersiveengineering:treated_wood_horizontal',
        count: 1
      }
    })

    mekcrush(item.of('minecraft:blaze_powder', 4), '#forge:rods/blaze')
    mekcrush(item.of('minecraft:quartz',4), '#forge:storage_blocks/quartz')
    mekenrichItem('minecraft:blaze_powder', 4, 'minecraft:blaze_rod', 1)

    removeOut('refinedstorage:silicon')
    event.smelting(item.of('refinedstorage:silicon'), ['#forge:gems/quartz', '#forge:gems/certus_quartz'])
})